/*
 * @(#)OMBshClass.java  1.0  23. M�rz 2004
 *
 * Copyright (c) 2003 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.oo.objectmodelbsh;

import bsh.*;
import ch.hslu.cm.oo.objectmodel.*;
import java.util.*;
/**
 * Simulates the structure and behavior of a class, methods can be described
 * using BeanShell scripts.
 * 
 * @author Werner Randelshofer
 * @version 1.0 23. M�rz 2004  Created.
 */
public class OMBshClass extends OMClass {
    private ClassNameSpace classNameSpace;
    
    /** Creates a new instance. */
    public OMBshClass() {
    }
    
    protected ObjectModelBsh getSimulationBsh() {
        return (ObjectModelBsh) getSimulation();
    }
    
    /**
     * Finds an operation with the provided name and which matches best the
     * provided arguments.
     *
     * @return A matching operation or null.
     */
    protected OMOperation findDeclaredOperation(String name, Class[] signature) {
        for (Iterator i = getOperations().iterator(); i.hasNext(); ) {
            OMOperation op = (OMOperation) i.next();
            if (op.getOperationName().equals(name)) {
                return op;
            }
        }
        return null;
    }
    
    public ClassNameSpace getClassNameSpace() {
        if (classNameSpace == null) {
            classNameSpace = new ClassNameSpace(this);
        }
        return classNameSpace;
    }
    
    /**
     * Invokes a method of an instance of this class.
     * Subclasses should override invokeMethodImpl to provide their own methods.
     * 
     * 
     * 
     * 
     * @param link The link used to access this class. Can be null.
     * @param instance An instance of this class.
     * @param name The name of the operation.
     * @param args The arguments.
     * @return Returns a SimulatedObject or Primitive.VOID or Primitive.NULL.
     * /
     *    public final Object invokeInstanceMethod(SimulatedLink link, SimulatedObjectBsh instance, String name, Object[] args)
     *    throws EvalError {
     *        instance.fireMethodEntered(link, name, true);
     *        Object response = null;
     *        try {
     *            OMBshClass declaringClass = this;
     *            OMOperation operation;
     *            do {
     *                operation = declaringClass.findDeclaredOperation(name, args);
     *            } while (operation == null && (declaringClass = (OMBshClass) declaringClass.getSuperclass()) != null);
     *            
     *            if (operation == null) {
     *                throw new EvalError("Verstehe Nachricht "+name+" nicht.", null, null);
     *            }
     *            
     *            Interpreter bsh = new Interpreter(getSimulationBsh().getConsole(), instance.getObjectNameSpace());
     *            response = bsh.eval(operation.getMethod());
     *            instance.fireMethodExited(link, response, false);
     *        } catch (EvalError e) {
     *            instance.fireMethodExited(link, response, true);
     *            throw e;
     *        }
     *        return response;
     *    }
     */
    public OMBshClass clone() {
        OMBshClass that = (OMBshClass) super.clone();
        that.classNameSpace = null;
        return that;
    }
    public OMAssociation findAssociationForLinkName(String linkName) {
        for (Iterator i=getRelationships(ObjectModelBsh.ASSOCIATION).iterator(); i.hasNext(); ) {
            OMAssociation a = (OMAssociation) i.next();
            if (a.getMemberLabel().equals(linkName)
            && a.getOwner().isAssignableFrom(this)) {
               return a;
            }
            if (a.getOwnerLabel().equals(linkName)
            && a.getMember().isAssignableFrom(this)) {
               return a;
            }
        }
        return null;
    }
}
